/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.parser.core;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.ast.ThematicBreak;
import icyllis.flexmark.parser.Parser;
import icyllis.flexmark.parser.block.AbstractBlockParser;
import icyllis.flexmark.parser.block.AbstractBlockParserFactory;
import icyllis.flexmark.parser.block.BlockContinue;
import icyllis.flexmark.parser.block.BlockParserFactory;
import icyllis.flexmark.parser.block.BlockStart;
import icyllis.flexmark.parser.block.CustomBlockParserFactory;
import icyllis.flexmark.parser.block.MatchedBlockParser;
import icyllis.flexmark.parser.block.ParserState;
import icyllis.flexmark.parser.core.BlockQuoteParser;
import icyllis.flexmark.parser.core.FencedCodeBlockParser;
import icyllis.flexmark.parser.core.HeadingParser;
import icyllis.flexmark.parser.core.HtmlBlockParser;
import icyllis.flexmark.parser.core.IndentedCodeBlockParser;
import icyllis.flexmark.parser.core.ListBlockParser;
import icyllis.flexmark.util.ast.Block;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ThematicBreakParser
extends AbstractBlockParser {
    static Pattern PATTERN = Pattern.compile("^(?:(?:\\*[ \t]*){3,}|(?:_[ \t]*){3,}|(?:-[ \t]*){3,})[ \t]*$");
    private final ThematicBreak block = new ThematicBreak();

    public ThematicBreakParser(BasedSequence line) {
        this.block.setChars(line);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.none();
    }

    static class ThematicBreakOptions {
        final boolean relaxedStart;

        public ThematicBreakOptions(DataHolder options) {
            this.relaxedStart = Parser.THEMATIC_BREAK_RELAXED_START.get(options);
        }
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final ThematicBreakOptions options;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new ThematicBreakOptions(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= 4 || matchedBlockParser.getBlockParser().isParagraphParser() && !this.options.relaxedStart) {
                return BlockStart.none();
            }
            BasedSequence line = state.getLine();
            BasedSequence input = line.subSequence(state.getNextNonSpaceIndex(), line.length());
            if (PATTERN.matcher(input).matches()) {
                return BlockStart.of(new ThematicBreakParser((BasedSequence)line.subSequence(state.getIndex()))).atIndex(line.length());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return new HashSet(Arrays.asList(BlockQuoteParser.Factory.class, HeadingParser.Factory.class, FencedCodeBlockParser.Factory.class, HtmlBlockParser.Factory.class));
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return new HashSet(Arrays.asList(ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

